# 🧩 Mes Codes Web  
### Affichage dynamique de fichiers HTML / CSS / JS depuis des fichiers externes `.md`

---

## 🚀 Description du projet  
Ce projet permet d’afficher le contenu de plusieurs fichiers de code (HTML, CSS, JS, etc.) directement sur une page web, en les chargeant dynamiquement depuis des fichiers externes au format **Markdown (.md)**.  

Il est conçu pour visualiser proprement du code, documenter des exemples, ou encore créer une bibliothèque personnelle de snippets.

---

## 📁 Structure du projet  

📂 mon-projet-codes-web
├── index.html
├── style.css
├── script.js
├── 📂 images/
│ └── fondusite01.jpg
├── 📂 texteexterne/
│ ├── html.md
│ ├── css.md
│ ├── js.md
│ └── autrecode.md
└── 📦 CodesContact.zip


---

## 🧱 Fonctionnement  

### 1️⃣ Chargement des codes  
Le script **`script.js`** charge automatiquement les fichiers Markdown 
à partir du dossier `texteexterne/` :  
- `html.md` → affiché dans `.bloccode1` (en texte brut)  
- `css.md` → affiché dans `.bloccode2` (interprété via Markdown)  
- `js.md` → affiché dans `.bloccode3`  
- `autrecode.md` → affiché dans `.bloccode4`  

Le chargement est effectué via la fonction **`fetch()`** 
et l’interprétation Markdown via la librairie **
[Marked.js](https://marked.js.org/)**.

---

### 2️⃣ Rendu visuel  
Le fichier **`style.css`** gère :  
- L’arrière-plan, les polices et la mise en page responsive.  
- Les blocs de code stylisés façon “GitHub”.  
- Les boutons et éléments décoratifs semi-transparents.

---

### 3️⃣ Téléchargement d’un dossier ZIP  
Un bouton permet de télécharger un dossier compressé (`CodesContact.zip`) 
contenant les fichiers sources (par exemple un formulaire ou un autre projet web).

---

## ⚙️ Technologies utilisées  

| Type | Technologie / Librairie | Description |
|------|--------------------------|-------------|
| 🌐 Frontend | **HTML5** | Structure principale du site |
| 🎨 Style | **CSS3** | Mise en page, flexbox et responsive |
| ⚡ Script | **JavaScript (ES6)** | Chargement dynamique et rendu Markdown |
| 📘 Librairie externe | **Marked.js** | Conversion Markdown → HTML |
| 🖼️ Design | **Fond d’écran + ombres + transparence** | Effet moderne et lisible |

---

## 🪶 Installation & utilisation  

1️⃣ **Télécharge** le projet ou clone le dépôt :  
git clone https://github.com/ton-compte/mes-codes-web.git
2️⃣ Place les fichiers Markdown à afficher 
dans le dossier texteexterne/ :

texteexterne/html.md
texteexterne/css.md
texteexterne/js.md
texteexterne/autrecode.md
3️⃣ Ouvre simplement index.html dans ton navigateur.
Le code se charge automatiquement sans serveur local nécessaire.

🧩 Personnalisation
Tu peux facilement adapter :

Les chemins de fichiers dans script.js 
(ex. pour afficher d’autres fichiers .md).

Les styles des blocs de code dans style.css.

Le titre, les boutons, les textes directement dans index.html.

🔒 Remarques
Assure-toi que les fichiers .md existent, 
sinon un message d’erreur s’affichera.

Si tu ouvres le fichier localement (sans serveur), 
certains navigateurs bloquent fetch(). 
Dans ce cas, utilise un petit serveur local comme :

npx serve
🧑‍💻 Auteur
Projet personnel – Mes Codes Web
Avec l'assistance de ChatGPT
