document.addEventListener("DOMContentLoaded", () => {
  const blocs = {
    blocAutre: document.querySelector(".bloccode1"),
    blocHTML: document.querySelector(".bloccode2"),
    blocCSS: document.querySelector(".bloccode3"),
    blocJS: document.querySelector(".bloccode4"),
  };

  function chargerCodeBrut(chemin, element) {
    if (!element) {
      console.warn("Élément manquant pour :", chemin);
      return;
    }

    fetch(chemin)
      .then(res => {
        if (!res.ok) throw new Error("Erreur de chargement : " + chemin);
        return res.text();
      })
      .then(txt => {
        element.textContent = txt;
        ajouterBoutonCopier(element, txt);
      })
      .catch(err => {
        element.textContent = "⚠️ Impossible de charger " + chemin;
        console.error(err);
      });
  }

  function chargerMarkdown(chemin, element) {
    if (!element) {
      console.warn("Élément manquant pour :", chemin);
      return;
    }

    fetch(chemin)
      .then(res => {
        if (!res.ok) throw new Error("Erreur de chargement : " + chemin);
        return res.text();
      })
      .then(txt => {
        element.innerHTML = marked.parse(txt);
        ajouterBoutonCopier(element, txt);
      })
      .catch(err => {
        element.textContent = "⚠️ Impossible de charger " + chemin;
        console.error(err);
      });
  }

  function ajouterBoutonCopier(element, contenu) {
    // Trouve le bloc .bloccode parent
    const blocParent = element.closest(".bloccode");
    if (!blocParent) {
      console.warn("Parent .bloccode introuvable pour l'élément :", element);
      return;
    }

    // Récupère le bandeau à l'intérieur du bloc
    const bandeau = blocParent.querySelector(".bandeau");
    if (!bandeau) {
      console.warn("Bandeau introuvable dans :", blocParent);
      return;
    }

    // Évite d'ajouter plusieurs boutons au même bandeau
    if (bandeau.querySelector(".copy-btn")) return;

    const bouton = document.createElement("button");
    bouton.className = "copy-btn";
    bouton.type = "button";
    bouton.textContent = "Copier";

    bouton.addEventListener("click", () => {
      // writeText peut échouer si site non sécurisé (http) ou permission refusée
      navigator.clipboard.writeText(contenu)
        .then(() => {
          bouton.textContent = "✅ Copié !";
          setTimeout(() => (bouton.textContent = "Copier"), 1500);
        })
        .catch(err => {
          console.error("Erreur copie :", err);
          bouton.textContent = "❌ Erreur";
          setTimeout(() => (bouton.textContent = "Copier"), 1500);
        });
    });

    // Ajoute le bouton dans le bandeau à droite du titre
    bandeau.appendChild(bouton);
  }

  // Chargement des fichiers (si fichiers introuvables, messages dans la console)
  chargerMarkdown("texteexterne/autrecode.md", blocs.blocAutre);
  chargerCodeBrut("texteexterne/html.md", blocs.blocHTML);
  chargerMarkdown("texteexterne/css.md", blocs.blocCSS);
  chargerMarkdown("texteexterne/js.md", blocs.blocJS);
});
